rm(list=ls())
library(cmdstanr)
library(bayesplot)
library(posterior)
library(mcmcplots)
library(magrittr)
library(multipanelfigure)
library(data.table)
library(tidylog)
library(tidyverse)

setwd("")



# We wish to estimate the percentage of people with a specific characteristic (say dependent on opioids) 
# in a region across six age-by-sex groups. We know the number of people (N) with this characteristic 
# in each demographic group and the total population (P).

data <- list(
   n=6,
   P=c(691165,506885,547164,687621,532921,580489),
   N=c(7400,18700,7800,3300,8900,3700),
   age_g2 = c(0,1,0,0,1,0),
   age_g3 = c(0,0,1,0,0,1),
   sex_g  = c(1,1,1,0,0,0)
)

head(data)  

example6 <- cmdstan_model("STAN/example6.stan")


initial_values <- list(
  list(gamma=rep(0,4)),
  list(gamma=rep(-0.5,4)),
  list(gamma=rep(0.5,4))
  )

example6_fit <- example6$sample(data=data,
                                seed=123,
                                iter_warmup=2000,
                                iter_sampling=2000,
                                chains = 3,
                                parallel_chains=3,
                               save_warmup = TRUE,
                               thin=1,
                               max_treedepth=15,
                               init=initial_values)
example6_fit$summary()
range(example6_fit$summary()$rhat)

round(example6_fit$summary()[which(example6_fit$summary()$variable %in% paste('prev[',1:6,']',sep='')),c('mean','q5','q95')]*100,2)






posterior_sample <- data.frame(example6_fit$draws(format = "matrix",inc_warmup = FALSE))

log_lik_theta_hat <- rep(0,6)
for(i in 1:6){
    log_lik_theta_hat[i] <- dbinom(data$N[i],data$P[i],mean(posterior_sample[,paste0('prev.',i,'.')]),log=TRUE)
}





total_log_lik_theta_hat <- sum(log_lik_theta_hat)
mean_log_lik_theta <- mean(posterior_sample[,'log_lik'])
#getwd()
pD <- 2 * (total_log_lik_theta_hat - mean_log_lik_theta)
DIC <- (-2 * total_log_lik_theta_hat) + (2*pD)
DIC3 <- (-2 * mean_log_lik_theta) + (pD)


